#include <vlib.h>

void main(void)
{
UWORD width, height;


    if(IsPCX("beholder.pcx") == FALSE)
        return;

    // Width and height in pcx files are 1 less than actual
    width = pcx_header.width + 1;
    height = pcx_header.height + 1;

    if(FindBestVesaMode(width, height, 8, FALSE) == FALSE)
        return;

    AllocDoubleBuffer(width * height);

    // Load picture right to double buffer
    LoadPCX("beholder.pcx", double_buffer, colormap);

    SetPalette(colormap);

    DoubleBuffer();

    SaveTGA("beholder.tga", double_buffer, width, height, colormap);

    Text(0, 0, "Press any key to exit", FindColor(colormap, 0x00ffffff));
    DoubleBuffer();

    WaitKey();

    FreeDoubleBuffer();
    SetVideoMode(TEXT80);

}